#include <stdlib.h>
#include <math.h>
#include "triangle.h"
#include "cvect.h"

/*
  c0
   c_   s3
   | --_
s1 |   _-c c2
   |_--
   c    s2
  c1
*/

triangle::triangle(void) {
  next = side[0] = side[1] = side[2] = NULL;
}

triangle::triangle(cvect c1, cvect c2, cvect c3) {
  locate(c1,c2,c3);
}

void triangle::locate(cvect c1, cvect c2, cvect c3) {
  corner[0] = c1;
  corner[1] = c2;
  corner[2] = c3;
  next = side[0] = side[1] = side[2] = NULL;
}

void triangle::flip(int axis) {
  //flip neighboring triangles

  if (match(*(side[axis%3])) < 0)  //if the neighboring triangle has same normal
    side[axis%3]->flip(side[axis%3]->match(*this)); //flip it
  if (match(*(side[(axis+1)%3])) < 0) //if the neighboring triangle has same normal
    side[(axis+1)%3]->flip(side[(axis+1)%3]->match(*this)); //flip it

  //flip this triangle

  //swap the corners
  cvect tempv = corner[axis-1];
  corner[axis-1] = corner[axis%3];
  corner[axis%3] = tempv;

  //swap the side links
  triangle * tempt = side[axis-1];
  side[axis-1] = side[axis%3];
  side[axis%3] = tempt;
}

int triangle::match(triangle& tri) {
  if (
     (corner[0] == tri.corner[0] && corner[1] == tri.corner[1] && corner[2] == tri.corner[2]) ||
     (corner[0] == tri.corner[1] && corner[1] == tri.corner[2] && corner[2] == tri.corner[0]) ||
     (corner[0] == tri.corner[2] && corner[1] == tri.corner[0] && corner[2] == tri.corner[1])
   )
     return -4;
   else if (corner[0] == tri.corner[0] && corner[1] == tri.corner[1])
     return 1;
   else if (corner[0] == tri.corner[1] && corner[1] == tri.corner[0])
     return -1;
   else if (corner[1] == tri.corner[1] && corner[2] == tri.corner[2])
     return 2;
   else if (corner[1] == tri.corner[2] && corner[2] == tri.corner[1])
     return -2;
   else if (corner[2] == tri.corner[2] && corner[0] == tri.corner[0])
     return 3;
   else if (corner[2] == tri.corner[0] && corner[0] == tri.corner[2])
     return -3;
   else
     return 0;
}

bool triangle::link(triangle * tri) {
  int m = match(*tri);
  if (m == 0 || m == -4)
    return false;
  if (m > 0)
    flip(m);
  side[m-1] = tri;
  m = tri->match(*this);
  if (m == 0 || m == -4)
    return false;
  tri->side[m-1] = this;
  return true;
}

bool triangle::exposed(void) {
  return side[0] == NULL || side[1] == NULL || side[2] == NULL;
}

double triangle::area(void) {
  double a, b, c, s;
  a = (corner[0] - corner[1]).length();
  b = (corner[1] - corner[2]).length();
  c = (corner[2] - corner[0]).length();
  s = (a + b + c) / 2;
  return sqrt(s * (s - a) * (s - b) * (s - c));
}

cvect triangle::normal(void) {
  cvect v1, v2, ret;
  v1 = corner[0] - corner[1];
  v2 = corner[2] - corner[1];
  ret = v1.cross(v2);
  return ret;
//  return (corner[0] - corner[1]).cross(corner[2] - corner[1]);
}

void triangle::print(void) {
  printf(
    "|{<%f,%f,%f>,<%f,%f,%f>,<%f,%f,%f>}.normal()| = ",
    corner[0][0],corner[0][1],corner[0][2],
    corner[1][0],corner[1][1],corner[1][2],
    corner[2][0],corner[2][1],corner[2][2]
  );
  normal().print();
}

triangle::~triangle(void) {
  if (next != NULL)
    delete next;
}
